const EmailFormFields = ({ formData, handleChange }) => {
return (
  <>
    <div className="form-group">
      <label className="form-label">Name</label>
      <input type="text" name="name"
        value={formData.name}
        onChange={handleChange}
        className="form-input"
        required
      />
    </div>
    <div className="form-group">
      <label className="form-label">Email</label>
      <input type="email" name="email"
        value={formData.email}
        onChange={handleChange}
        className="form-input"
        required
      />
    </div>
    <div className="form-group">
      <label className="form-label">Message</label>
      <textarea name="message" 
        value={formData.message}
        onChange={handleChange}
        className="form-input"
        rows="6"
        required
      ></textarea>
    </div>
  </>
);
};

export default EmailFormFields;
