import { useState } from "react";
import emailjs from "emailjs-com";
import { ToastContainer, toast } from "react-toastify";
import "react-toastify/dist/ReactToastify.css";
import "../../public/assets/css/phppot-style.css";
import EmailFormFields from "./EmailFormFields";

const EmailForm = () => {
  const [formData, setFormData] = useState({
    name: "",
    email: "",
    message: "",
  });

  const handleChange = (e) => {
    const { name, value } = e.target;
    setFormData((prev) => ({ ...prev, [name]: value }));
  };

  const handleSubmit = (e) => {
    e.preventDefault();

    const SERVICE_ID = "Your Serivce ID"; 
    const TEMPLATE_ID = "Your Template ID"; 
    const PUBLIC_KEY = "EmailJS API Public key here";

    emailjs
      .send(SERVICE_ID, TEMPLATE_ID, formData, PUBLIC_KEY)
      .then(() => {
        toast.success("Email sent successfully!", { position: "top-center" });
        setFormData({ name: "", email: "", message: "" });
      })
      .catch(() => {
        toast.error("Failed to send email. Please try again.", {
          position: "top-center",
        });
      });
  };

  return (
    <div className="form-wrapper">
      <h2 className="form-title">Contact Us</h2>
      <form onSubmit={handleSubmit} className="payment-form">
        <EmailFormFields formData={formData} handleChange={handleChange} />
        <button type="submit" className="submit-btn">
          Send
        </button>
      </form>
      <ToastContainer />
    </div>
  );
};

export default EmailForm;
