import { useState } from "react";
import menuData from "./MenuData";
import Dropdown from "./DropDown";
import "../../../public/assets/css/style.css";

const Navbar = () => {
  const [menuOpen, setMenuOpen] = useState(false);
  const [openIndex, setOpenIndex] = useState(null); 

  const toggleSubmenu = (index, e) => {
    if (window.innerWidth <= 768) {
      e.preventDefault(); 
      setOpenIndex(openIndex === index ? null : index);
    }
  };

return (
  <nav className="navbar">
    <div className="navbar-container">
      <h2 className="logo">𝓣𝓸𝔂𝓢𝓽𝓸𝓻𝓮</h2>
      <button
        className="menu-toggle"
        onClick={() => setMenuOpen(!menuOpen)}
        aria-label="Toggle menu"
      >
        ☰
      </button>
      <ul className={`menu ${menuOpen ? "open" : ""}`}>
        {menuData.map((menu, i) => (
          <li key={i} className="menu-item has-submenu">
            <a href="#" onClick={(e) => toggleSubmenu(i, e)}>
              {menu.title}
              <span className="expand">▼</span>
            </a>
            {menu.subMenu && (
              <Dropdown
                items={menu.subMenu}
                className={openIndex === i ? "open" : ""}
              />
            )}
          </li>
        ))}
      </ul>
    </div>
  </nav>
);
};

export default Navbar;
