import { useState } from "react";

const Dropdown = ({ items, className }) => {
  const [openIndex, setOpenIndex] = useState(null);

  const toggleSubmenu = (index, e) => {
    if (window.innerWidth <= 768) {
      e.preventDefault();
      setOpenIndex(openIndex === index ? null : index);
    }
  };

  return (
    <ul className={`dropdown ${className || ""}`}>
      {items.map((item, i) =>
        typeof item === "string" ? (
          <li key={i}>
            <a href="#">{item}</a>
          </li>
        ) : (
          <li key={i} className="has-submenu">
            <a href="#" onClick={(e) => toggleSubmenu(i, e)}>
              {item.title}
              <span className="expand">›</span>
            </a>
            {item.subMenu && (
              <Dropdown
                items={item.subMenu}
                className={openIndex === i ? "open" : ""}
              />
            )}
          </li>
        )
      )}
    </ul>
  );
};

export default Dropdown;
