import {
  MDBBtn,
  MDBCard,
  MDBCardBody,
  MDBCardHeader,
  MDBCol,
  MDBContainer,
  MDBIcon,
  MDBInput,
  MDBListGroup,
  MDBListGroupItem,
  MDBRipple,
  MDBRow,
  MDBTooltip,
  MDBTypography,
} from "mdb-react-ui-kit";
import React, { useState, useEffect } from "react";

import "mdb-react-ui-kit/dist/css/mdb.min.css";
import "@fortawesome/fontawesome-free/css/all.min.css";

export default function PaymentMethods() {
  

  const initialCart = [
    {
      id: 1,
      name: "Blue OceanStep Duo",
      color: "blue",
      size: "M",
      price: 17.99,
      qty: 0,
      img: "images/blue.jpg",
    },
    {
      id: 2,
      name: "Red Royal Walkers",
      color: "red",
      size: "M",
      price: 17.99,
      qty: 0,
      img: "images/yellow.png",
    },
  ];

  // Store cart items in a localStorage
  const [cart, setCart] = useState(() => {
    const storedCart = localStorage.getItem("cart");
    return storedCart ? JSON.parse(storedCart) : initialCart;
  });

  useEffect(() => {
    localStorage.setItem("cart", JSON.stringify(cart));
  }, [cart]);

  
  const incrementQty = (id) => {
    setCart((prev) =>
      prev.map((item) =>
        item.id === id ? { ...item, qty: item.qty + 1 } : item
      )
    );
  };

  const decrementQty = (id) => {
    setCart((prev) =>
      prev.map((item) =>
        item.id === id && item.qty > 0 ? { ...item, qty: item.qty - 1 } : item
      )
    );
  };

  const removeItem = (id) => {
    setCart((prev) => prev.filter((item) => item.id !== id));
  };

  const total = cart.reduce((acc, item) => acc + item.price * item.qty, 0);

  // Go to checkout button handler
  const handleCheckout = async () => {
      try {
        const response = await fetch('http://localhost/react-stripe-action/ajax/create-checkout-session.php', {
          method: 'POST',
          headers: { 'Content-Type': 'application/json' },
          body: JSON.stringify({ unitPrice: total, cartItems: cart })
        });
        const session = await response.json();
        var responseObj = JSON.parse(session);
        console.log('Checkout session:', responseObj.checkout_url);

        if (responseObj.checkout_url != "") {
         window.location.href = responseObj.checkout_url;
        }
        
      } catch (error) {
        console.error('Error:', error);
      }
  };

  return (
    <section className="h-100 gradient-custom">
      <MDBContainer fluid className="w-100">
        <MDBRow className="justify-content-center py-4">
          <MDBCol md="8">
            <MDBCard className="mb-4">
              <MDBCardHeader className="py-3">
                <MDBTypography tag="h5" className="mb-0">
                  Cart - {cart.length} items
                </MDBTypography>
              </MDBCardHeader>
              <MDBCardBody>
                {cart.map((item) => (
                  <React.Fragment key={item.id}>
                    <MDBRow>
                      <MDBCol lg="3" md="12" className="mb-4 mb-lg-0" style={{ width: '16%' }} >
                        <MDBRipple
                          rippleTag="div"
                          rippleColor="light"
                          className="bg-image rounded hover-zoom hover-overlay"
                        >
                          <img src={item.img} className="w-100" alt={item.name}
                            style={{ width: '120px', height: '120px', objectFit: 'cover' }} />
                          <a href="">
                            <div
                              className="mask"
                              style={{
                                backgroundColor: "rgba(251, 251, 251, 0.2)",
                              }}
                            ></div>
                          </a>
                        </MDBRipple>
                      </MDBCol>

                      <MDBCol lg="5" md="6" className=" mb-4 mb-lg-0">
                        <p>
                          <strong>{item.name}</strong>
                        </p>
                        <p>Color: {item.color}</p>
                        <p>Size: {item.size}</p>

                        <MDBTooltip
                          wrapperProps={{ size: "sm" }}
                          wrapperClass="me-1 mb-2"
                          title="Remove item"
                        >
                          <MDBIcon
                            fas
                            icon="trash"
                            style={{ cursor: "pointer" }}
                            onClick={() => removeItem(item.id)}
                          />
                        </MDBTooltip>

                        {}
                      </MDBCol>

                      <MDBCol lg="4" md="6" className="mb-4 mb-lg-0">
                        <div className="d-flex mb-4" style={{ maxWidth: "300px" }}>
                          <MDBBtn
                            className="px-3 me-2"
                            onClick={() => decrementQty(item.id)}
                            disabled={item.qty === 0}
                          >
                            <MDBIcon fas icon="minus" />
                          </MDBBtn>

                          <MDBInput
                            value={item.qty}
                            min={0}
                            type="number"
                            label="Quantity"
                            readOnly
                          />

                          <MDBBtn
                            className="px-3 ms-2"
                            onClick={() => incrementQty(item.id)}
                          >
                            <MDBIcon fas icon="plus" />
                          </MDBBtn>
                        </div>

                        <p className="text-start text-md-center">
                          <strong>${(item.price * item.qty).toFixed(2)}</strong>
                        </p>
                      </MDBCol>
                    </MDBRow>


                    <hr className="my-4" />
                  </React.Fragment>
                ))}

              </MDBCardBody>


            </MDBCard>
            {/* --- Add Products Gallery --- */}
            <MDBCard className="mb-4">
              <MDBCardHeader>
                <MDBTypography tag="h5" className="mb-0">
                  Add Products
                </MDBTypography>
              </MDBCardHeader>
              <MDBCardBody>
                <MDBRow>
                  {initialCart.map((item) => (
                    <MDBCol key={item.id} md="3" className="mb-4">
                      <MDBCard>
                        <MDBRipple
                          rippleTag="div"
                          rippleColor="light"
                          className="bg-image rounded hover-zoom hover-overlay"
                          style={{ display: "flex", justifyContent: "center", alignItems: "center", height: "120px" }}

                        >
                          <img
                            src={item.img}
                            alt={item.name}
                            style={{ width: "120px", height: "120px", objectFit: "cover" }}
                          />
                        </MDBRipple>
                        <MDBCardBody className="text-center">
                          <p>{item.name}</p>
                          <MDBBtn
                            size="sm"
                            onClick={() => {
                              setCart((prev) => {
                                // If item exists, increment qty, otherwise add it
                                const exists = prev.find((i) => i.id === item.id);
                                if (exists) {
                                  return prev.map((i) =>
                                    i.id === item.id ? { ...i, qty: i.qty + 1 } : i
                                  );
                                } else {
                                  return [...prev, { ...item, qty: 1 }];
                                }
                              });
                            }}
                          >
                            Add to Cart
                          </MDBBtn>
                        </MDBCardBody>
                      </MDBCard>
                    </MDBCol>
                  ))}
                </MDBRow>
              </MDBCardBody>
            </MDBCard>
          </MDBCol>

          <MDBCol md="4">
            <MDBCard className="mb-4">
              <MDBCardHeader>
                <MDBTypography tag="h5" className="mb-0">
                  Summary
                </MDBTypography>
              </MDBCardHeader>
              <MDBCardBody>
                <MDBListGroup flush="true">
                  <MDBListGroupItem className="d-flex justify-content-between align-items-center border-0 px-0 pb-0">
                    Products
                    <span>${total.toFixed(2)}</span>
                  </MDBListGroupItem>
                  <MDBListGroupItem className="d-flex justify-content-between align-items-center px-0 border-0">
                    Shipping
                    <span>$0.00</span>
                  </MDBListGroupItem>
                  <MDBListGroupItem className="d-flex justify-content-between align-items-center border-0 px-0 mb-3">
                    <div>
                      <strong>Total amount</strong>
                      <strong>
                        <p className="mb-0">(including VAT)</p>
                      </strong>
                    </div>
                    <span>
                      <strong>${total.toFixed(2)}</strong>
                    </span>
                  </MDBListGroupItem>
                </MDBListGroup>


                <MDBBtn block size="lg" onClick={handleCheckout}>
                  Go to checkout
                </MDBBtn>
              </MDBCardBody>
            </MDBCard>
          </MDBCol>
        </MDBRow>
      </MDBContainer>
    </section>
  );
}
