import React from 'react';
import { BrowserRouter as Router, Routes, Route } from 'react-router-dom';
import ReactStripeIntegration from './components/ReactStripeIntegration';
import StripePaymentSuccess from './components/StripePaymentSuccess';
import StripePaymentCancel from './components/StripePaymentCancel';
import './App.css';

const App = () => {
  return (
    <Router>
      <Routes>
        <Route path="/" element={<ReactStripeIntegration />} />
        <Route path="/success" element={<StripePaymentSuccess />} />
        <Route path="/cancel" element={<StripePaymentCancel />} />
      </Routes>
    </Router>
  );
};

export default App;
