<?php
namespace Phppot;

use Slim\Http\Request;
use Slim\Http\Response;
use Stripe\Stripe;


require_once __DIR__ . '/../config.php';

class StripeService
{
    function __construct()
    {
        require_once __DIR__ . "/../vendor/autoload.php";
        \Stripe\Stripe::setApiKey(Config::STRIPE_SECRET_KEY);
    }

    public function createCheckoutSession($lineItems, $clientReferenceId)
    {
        $checkout_session = \Stripe\Checkout\Session::create([
        'payment_method_types' => ['card'],
            'line_items' => $lineItems,
            'mode' => 'payment',
            'client_reference_id' => $clientReferenceId,
            'success_url' => 'http://localhost:5173/success',
            'cancel_url' => 'http://localhost:5173/cancel',
        ]);
        return json_encode(['checkout_url' => $checkout_session->url]);
    }
}