<?php
namespace Phppot;

use Phppot\DataSource;

class StripePayment
{

    private $ds;

    function __construct()
    {
        require_once __DIR__ . "/../lib/DataSource.php";
        $this->ds = new DataSource();
    }

    public function insertOrder($unitAmount, $currency, $orderReferenceId, $orderStatus)
    {
        $orderAt = date("Y-m-d H:i:s");

        $insertQuery = "INSERT INTO tbl_order(order_reference_id, amount, currency, order_at, order_status) VALUES (?, ?, ?, ?, ?) ";

        $paramValue = array(
            $orderReferenceId,
            $unitAmount,
            $currency,
            $orderAt,
            $orderStatus
        );

        $paramType = "sisss";
        $insertId = $this->ds->insert($insertQuery, $paramType, $paramValue);
        return $insertId;
    }
}
?>