<?php
namespace Phppot;
ini_set('display_errors', 1);
header("Access-Control-Allow-Origin: http://localhost:5173");
header("Access-Control-Allow-Methods: POST, GET, OPTIONS");
header("Access-Control-Allow-Headers: Content-Type");

// Handle preflight requests
if ($_SERVER['REQUEST_METHOD'] === 'OPTIONS') {
    http_response_code(200);
    exit();
}

ini_set('display_errors', 1);
use Phppot\StripeService;
use Phppot\StripePayment;
$content = trim(file_get_contents("php://input"));

$jsondecoded = json_decode($content, true);
$orderReferenceId = rand(100000, 999999);

require_once __DIR__ . "/../lib/StripeService.php";
require_once __DIR__ .'/../config.php';
require_once __DIR__ . '/../lib/StripePayment.php';
$stripePayment = new StripePayment();

$stripeService = new StripeService();

$currency = Config::CURRENCY;

$unitPrice = $jsondecoded["unitPrice"];

$orderId = $stripePayment->insertOrder($unitPrice, $currency, $orderReferenceId, "Payment in-progress");

$lineItems = [];
foreach($jsondecoded["cartItems"] as $cartItems) {
      $lineItems[] = [
         'price_data' => [
               'currency' => $currency,
               'product_data' => [
                  'name' => $cartItems["name"],
               ],
               'unit_amount' => $cartItems["price"] * 100, // Amount in cents
         ],
         'quantity' => $cartItems["qty"],
      ];
}
$session = $stripeService->createCheckoutSession($lineItems, $orderId);
echo json_encode($session);