<?php
header("Access-Control-Allow-Origin: *");
header("Access-Control-Allow-Methods: POST, OPTIONS");
header("Access-Control-Allow-Headers: Content-Type");

if ($_SERVER['REQUEST_METHOD'] === 'OPTIONS') exit();

require_once 'db.php';

$data = json_decode(file_get_contents('php://input'), true);
$cart = $data['cart'] ?? [];

if (empty($cart)) {
    echo json_encode(["success" => false, "message" => "Cart is empty"]);
    exit;
}

// Prepare statement
$stmt = $conn->prepare("INSERT INTO checkout_items 
    (product_id, name, category, price, image, quantity, created_at) 
    VALUES (?, ?, ?, ?, ?, ?, NOW())");

// Loop through cart
foreach ($cart as $item) {
    $stmt->bind_param(
        "issdsi",
        $item['id'],
        $item['name'],
        $item['category'],
        $item['price'],
        $item['image'],
        $item['quantity']
    );
    $stmt->execute();
}

$stmt->close();

echo json_encode(["success" => true, "message" => "Cart saved successfully"]);
?>
