// src/components/Products.js
import React, { useState, useEffect } from "react";
import "./Product.css";

const productData = [
  { id: 1, name: "Grapes", category: "Fruits", price: 4.99, image: "img/fruite-item-5.jpg" },
  { id: 2, name: "Raspberries", category: "Fruits", price: 4.99, image: "img/fruite-item-2.jpg" },
  { id: 3, name: "Apple", category: "Fruits", price: 4.99, image: "img/fruite-item-6.jpg" },
  { id: 4, name: "Banana", category: "Fruits", price: 4.99, image: "img/fruite-item-3.jpg" },
  { id: 5, name: "Bread", category: "Bread", price: 5.99, image: "img/bread-item.jpg" },
  { id: 6, name: "Meat", category: "Meat", price: 4.99, image: "img/meat-item.jpg" },
  { id: 7, name: "Broccoli", category: "Vegetables", price: 4.99, image: "img/vegetable-item-2.jpg" },
  { id: 8, name: "Tomato", category: "Vegetables", price: 5.99, image: "img/vegetable-item-1.jpg" }
];

const Product = () => {
  const [loadingId, setLoadingId] = useState(null);
  const [addedId, setAddedId] = useState(null);
  const [selectedCategory, setSelectedCategory] = useState("All");

  useEffect(() => {
    document.title = "React Shopping Cart";
  }, []);


  const addToCart = (product) => {
    setLoadingId(product.id); // show spinner

    setTimeout(() => {
      // Add to localStorage
      let cart = JSON.parse(localStorage.getItem("cart")) || [];
      const existing = cart.find((item) => item.id === product.id);

      if (existing) {
        existing.quantity += 1;
      } else {
        cart.push({ ...product, quantity: 1 });
      }

      localStorage.setItem("cart", JSON.stringify(cart));

      // Update Navbar cart count
      const totalItems = cart.reduce((sum, item) => sum + item.quantity, 0);
      window.dispatchEvent(new CustomEvent("cartUpdated", { detail: totalItems }));
      setLoadingId(null);
      setAddedId(product.id);
    }, 1000);
  };

  const filteredProducts =
    selectedCategory === "All"
      ? productData
      : productData.filter((p) => p.category === selectedCategory);


  return (
    <section className="product-section">
      <div className="product-container">
        <div className="product-header">

          <ul className="product-tabs">
            <li className="tab-item" onClick={() => setSelectedCategory("All")}>
              <a className={`tab-link ${selectedCategory === "All" ? "active" : ""}`}>
                <span>All Products</span>
              </a>
            </li>
            <li className="tab-item" onClick={() => setSelectedCategory("Vegetables")}>
              <a className={`tab-link ${selectedCategory === "Vegetables" ? "active" : ""}`}>
                <span>Vegetables</span>
              </a>
            </li>
            <li className="tab-item" onClick={() => setSelectedCategory("Fruits")}>
              <a className={`tab-link ${selectedCategory === "Fruits" ? "active" : ""}`}>
                <span>Fruits</span>
              </a>
            </li>
            <li className="tab-item" onClick={() => setSelectedCategory("Bread")}>
              <a className={`tab-link ${selectedCategory === "Bread" ? "active" : ""}`}>
                <span>Bread</span>
              </a>
            </li>
            <li className="tab-item" onClick={() => setSelectedCategory("Meat")}>
              <a className={`tab-link ${selectedCategory === "Meat" ? "active" : ""}`}>
                <span>Meat</span>
              </a>
            </li>
          </ul>
        </div>

        <div className="product-grid">
          {filteredProducts.map((product) => (
            <div className="product-card" key={product.id}>
              <div className="product-image-container">
                <img src={product.image} alt={product.name} className="product-image" />
                <div className="product-category-tag">{product.category}</div>
              </div>
              <div className="product-details">
                <h4>{product.name}</h4>
                <p>Lorem ipsum dolor sit amet consectetur adipisicing elit.</p>
                <div className="product-info-row">
                  <p className="product-price">${product.price.toFixed(2)} / kg</p>
                  <button
                    className="add-to-cart-btn"
                    onClick={() => addToCart(product)}
                    disabled={addedId === product.id || loadingId === product.id}
                    style={{
                      backgroundColor: addedId === product.id ? "#81c408" : undefined,
                      color: addedId === product.id ? "#fff" : undefined,
                    }}
                  >
                    {loadingId === product.id ? (
                      <img
                        src="img/loader.svg"
                        alt="Loading..."
                        style={{ width: "20px", height: "20px" }}
                      />
                    ) : addedId === product.id ? (
                      "Added"
                    ) : (
                      <>
                        <i className="fa fa-shopping-bag cart-icon"></i> Add to cart
                      </>
                    )}
                  </button>
                </div>
              </div>
            </div>
          ))}
        </div>
      </div>
    </section>
  );
};

export default Product;
