// src/components/Navbar.js
import React from 'react';
import { useState, useEffect } from "react";
import '@fortawesome/fontawesome-free/css/all.min.css';
import { FontAwesomeIcon } from "@fortawesome/react-fontawesome";
import { faShoppingBag, faTableCellsLarge } from "@fortawesome/free-solid-svg-icons";
import { Link } from "react-router-dom";
import './Navbar.css';


const Navbar = () => {
  const [cartCount, setCartCount] = useState(0);

  useEffect(() => {
    // Initial load
    const cart = JSON.parse(localStorage.getItem("cart")) || [];
    const totalItems = cart.reduce((sum, item) => sum + item.quantity, 0);
    setCartCount(totalItems);

    // Listen for cart updates
    const handleCartUpdate = (e) => setCartCount(e.detail);
    window.addEventListener("cartUpdated", handleCartUpdate);

    return () => window.removeEventListener("cartUpdated", handleCartUpdate);
  }, []);

  return (
    <div className="navbar-container">
      <div className="navbar-wrapper">
        <nav className="navbar" style={{ display: 'flex', flexWrap: 'nowrap' }}>
          <div className="navbar-brand">
            <h1 className="brand-title">FruitsCart</h1>
          </div>
          <div className="navbar-collapse">
            <div className="navbar-nav">
            </div>
            <div className="navbar-icons">
              <Link to="/cart-page" className="icon-link cart-link">
                <FontAwesomeIcon icon={faShoppingBag} size="2x" style={{ color: "#81c408" }} />
                {cartCount > 0 && <span className="cart-badge">{cartCount}</span>}
              </Link>

              <Link to="/" href="#" className="icon-link menu-link">
                <FontAwesomeIcon icon={faTableCellsLarge} size="2x" style={{ color: "#81c408", margin: "12px" }} />
              </Link>
            </div>
          </div>
        </nav>
      </div>
    </div>
  );
};

export default Navbar;