import express from "express";
import cors from "cors";
import bodyParser from "body-parser";
import userRoutes from "./routes/userRoutes.js";

const app = express();

app.use(cors());
app.use(bodyParser.json());

// Routes
app.use("/api/users", userRoutes);

app.get("/", (req, res) => res.send("API is running..."));

const PORT = 5000;
app.listen(PORT, () => console.log(`Server running on port ${PORT}`));
