import db from "../db.js";

export const getUsers = (req, res) => {
  db.query("SELECT * FROM users", (err, results) => {
    if (err) return res.status(500).json({ error: err.message });
    res.json(results);
  });
};

export const addUser = (req, res) => {
  const { name, username } = req.body;
  db.query("INSERT INTO users (name, username) VALUES (?, ?)", [name, username], (err, result) => {
    if (err) return res.status(500).json({ error: err.message });
    res.json({ id: result.insertId, name, username });
  });
};

export const updateUser = (req, res) => {
  const { id } = req.params;
  const { name, username } = req.body;
  db.query("UPDATE users SET name=?, username=? WHERE id=?", [name, username, id], (err) => {
    if (err) return res.status(500).json({ error: err.message });
    res.json({ id, name, username });
  });
};

export const deleteUser = (req, res) => {
  const { id } = req.params;
  db.query("DELETE FROM users WHERE id=?", [id], (err) => {
    if (err) return res.status(500).json({ error: err.message });
    res.json({ message: "User deleted" });
  });
};
