import { useState } from "react";

const PersonalInfo = ({ formData, handleChange, nextStep, prevStep }) => {
  const [errors, setErrors] = useState({});
  const validate = () => {
    const newErrors = {};
    if (!formData.dob) newErrors.dob = "Please select your date of birth";
    if (!formData.gender) newErrors.gender = "Please select your gender";
    setErrors(newErrors);
    return Object.keys(newErrors).length === 0;
  };
return (
  <div className="page">
    <div className="title">Personal Information</div>
    <div className="field">
      <div className="label">DOB</div>
      <input
        type="date"
        name="dob"
        value={formData.dob}
        onChange={handleChange}
        className={errors.dob ? "is-invalid" : ""}
      />
      {errors.dob && <div className="ribbon-alert">{errors.dob}</div>}
    </div>
    <div className="field">
      <div className="label">Gender</div>
      <select
        name="gender"
        value={formData.gender}
        onChange={handleChange}
        className={errors.gender ? "is-invalid" : ""}
      >
        <option value="">Select Gender</option>
        <option>Male</option>
        <option>Female</option>
        <option>Other</option>
      </select>
      {errors.gender && <div className="ribbon-alert">{errors.gender}</div>}
    </div>
    <div className="field btns">
      <button type="button" onClick={prevStep}>Back</button>
      <button type="button" onClick={() => validate() && nextStep()}>Continue</button>
    </div>
  </div>
);
};

export default PersonalInfo;
