import { useState } from "react";

const GeneralInfo = ({ formData, handleChange, nextStep }) => {
  const [errors, setErrors] = useState({});
  const validate = () => {
    const newErrors = {};
    if (!formData.first_name.trim()) newErrors.first_name = "First name is required";
    if (!formData.last_name.trim()) newErrors.last_name = "Last name is required";
    setErrors(newErrors);
    return Object.keys(newErrors).length === 0;
  };

  return (
    <div className="page slidepage">
      <div className="title">General Information</div>
      <div className="field">
        <div className="label">First Name</div>
        <input
          type="text"
          name="first_name"
          value={formData.first_name}
          onChange={handleChange}
          className={errors.first_name ? "is-invalid" : ""}
        />
        {errors.first_name && <div className="ribbon-alert">{errors.first_name}</div>}
      </div>
      <div className="field">
        <div className="label">Last Name</div>
        <input
          type="text"
          name="last_name"
          value={formData.last_name}
          onChange={handleChange}
          className={errors.last_name ? "is-invalid" : ""}
        />
        {errors.last_name && <div className="ribbon-alert">{errors.last_name}</div>}
      </div>
      <div className="field nextBtn">
        <button type="button" onClick={() => validate() && nextStep()}>
          Continue
        </button>
      </div>
    </div>
  );
};

export default GeneralInfo;
