import { useState } from "react";

const ContactInfo = ({ formData, handleChange, nextStep, prevStep }) => {
  const [errors, setErrors] = useState({});
  const validate = () => {
    const newErrors = {};
    const emailRegex = /^[^\s@]+@[^\s@]+\.[^\s@]+$/;
    if (!formData.email.trim()) newErrors.email = "Email is required";
    else if (!emailRegex.test(formData.email)) newErrors.email = "Enter a valid email address";
    if (formData.phone.length < 10) newErrors.phone = "Phone number must be at least 10 digits";
    setErrors(newErrors);
    return Object.keys(newErrors).length === 0;
  };

  return (
    <div className="page">
      <div className="title">Contact Information</div>
      <div className="field">
        <div className="label">Email Address</div>
        <input
          type="text"
          name="email"
          value={formData.email}
          onChange={handleChange}
          className={errors.email ? "is-invalid" : ""}
        />
        {errors.email && <div className="ribbon-alert">{errors.email}</div>}
      </div>
      <div className="field">
        <div className="label">WhatsApp Number</div>
        <input
          type="number"
          name="phone"
          value={formData.phone}
          onChange={handleChange}
          className={errors.phone ? "is-invalid" : ""}
        />
        {errors.phone && <div className="ribbon-alert">{errors.phone}</div>}
      </div>
      <div className="field btns">
        <button type="button" onClick={prevStep}>Back</button>
        <button type="button" onClick={() => validate() && nextStep()}>Continue</button>
      </div>
    </div>
  );
};

export default ContactInfo;
