import { useState } from "react";
import { toast } from "react-toastify";
import "react-toastify/dist/ReactToastify.css";
import axios from "axios";
import SERVER_SIDE_API_ROOT from "../../config";

const Confirmation = ({ formData, handleChange, prevStep, setFormData, setStep }) => {
  const [errors, setErrors] = useState({});
  const handleSubmit = async (e) => {
    e.preventDefault();
    const newErrors = {};
    if (!formData.username) newErrors.username = "Username is required";
    if (!formData.password) newErrors.password = "Password is required";
    else if (formData.password.length < 6) newErrors.password = "Password must be at least 6 characters";
    if (!formData.terms) newErrors.terms = "You must agree to the terms";
    setErrors(newErrors);
    if (Object.keys(newErrors).length > 0) return;
    try {
      const res = await axios.post(`${SERVER_SIDE_API_ROOT}/multi-step-form.php`, formData);
      if (res.data.success) {
        toast.success(res.data.message || "User registered successfully!");
        setFormData({
          first_name: "",
          last_name: "",
          email: "",
          phone: "",
          dob: "",
          gender: "",
          username: "",
          password: "",
          terms: false,
        });
        setStep(1);
        setErrors({});
      } else {
        toast.error(res.data.message || "Registration failed!");
      }
    } catch (err) {
      console.error(err);
      toast.error("Error while saving user data.");
    }
  };
  const renderError = (field) =>
  errors[field] ? <div className="ribbon-alert">{errors[field]}</div> : null;

return (
  <div className="page">
    <div className="title">Confirm</div>
    <div className="field">
      <div className="label">Username</div>
      <input
        type="text"
        name="username"
        value={formData.username}
        onChange={handleChange}
        className={errors.username ? "is-invalid" : ""}
      />
      {renderError("username")}
    </div>
    <div className="field">
      <div className="label">Password</div>
      <input
        type="password"
        name="password"
        value={formData.password}
        onChange={handleChange}
        className={errors.password ? "is-invalid" : ""}
      />
      {renderError("password")}
    </div>
    <div className="field-terms">
      <label>
        <input
          type="checkbox"
          name="terms"
          checked={formData.terms}
          onChange={handleChange}
        />{" "}
        I agree with the terms.
      </label>
      {renderError("terms")}
    </div>
    <div className="field btns">
      <button type="button" onClick={prevStep}>Back</button>
      <button type="submit" onClick={handleSubmit}>Register</button>
    </div>
  </div>
);
};

export default Confirmation;
