<?php
header("Access-Control-Allow-Origin: *");
header("Access-Control-Allow-Headers: Content-Type");
header("Access-Control-Allow-Methods: POST");
header("Content-Type: application/json");

include 'db.php';

$data = json_decode(file_get_contents("php://input"), true);

$firstName = $data["first_name"] ?? "";
$lastName  = $data["last_name"] ?? "";
$email     = $data["email"] ?? "";
$phone     = $data["phone"] ?? "";
$dob       = $data["dob"] ?? "";
$gender    = $data["gender"] ?? "";
$username  = $data["username"] ?? "";
$password  = $data["password"] ?? "";

if (!$firstName || !$email || !$password) {
  echo json_encode(["success" => false, "message" => "Required fields missing"]);
  exit;
}
if (!filter_var($email, FILTER_VALIDATE_EMAIL)) {
  echo json_encode(["success" => false, "message" => "Invalid email"]);
  exit;
}
if (strlen($password) < 6) {
  echo json_encode(["success" => false, "message" => "Password too short"]);
  exit;
}
$hashedPassword = password_hash($password, PASSWORD_BCRYPT);

$stmt = $conn->prepare("INSERT INTO users (first_name, last_name, email, phone, dob, gender, username, password) VALUES (?, ?, ?, ?, ?, ?, ?, ?)");
$stmt->bind_param("ssssssss", $firstName, $lastName, $email, $phone, $dob, $gender, $username, $hashedPassword);

if ($stmt->execute()) {
  echo json_encode(["success" => true, "message" => "User registered successfully"]);
} else {
  echo json_encode(["success" => false, "message" => "DB insert failed"]);
}
?>
