import React, { useEffect, useState } from "react";
import { useNavigate } from "react-router-dom";
import { jwtDecode } from "jwt-decode";
import "../styles/style.css";

const Dashboard = () => {
  const [user, setUser] = useState(null);
  const navigate = useNavigate();

  useEffect(() => {
    const token = localStorage.getItem("token");

    if (!token) {
      navigate("/login");
      return;
    }

    try {
      const decoded = jwtDecode(token);
      setUser(decoded.user);
    } catch (error) {
      console.error("Invalid token:", error);
      localStorage.removeItem("token");
      navigate("/login");
    }
  }, [navigate]);

  if (!user) return <p>Loading...</p>;

  const handleLogout = () => {
    localStorage.removeItem("token");
    navigate("/login");
  };

  return (
    <div className="dashboard-wrapper">
      <nav className="navbar">
        <div className="navbar-left">
          <h2>Dashboard</h2>
        </div>

        <div className="navbar-right">
          <button className="logout-btn" onClick={handleLogout}>
            <img src="./logout.svg" alt="Logout" className="logout-icon" />
          </button>
        </div>
      </nav>

      <div className="card">
        <img src="/profile.jpg" alt="" className="profile-pic" />
        <h2>Welcome, {user.username}</h2>
        <p>
          <strong>Email:</strong> {user.email}
        </p>
      </div>
    </div>
  );
};

export default Dashboard;
