import React, { useState } from "react";
import { Link } from "react-router-dom";
import SERVER_SIDE_API_ROOT from "../config";
import "../styles/style.css";
import axios from "axios";


const LoginForm = () => {
    const [formData, setFormData] = useState({
        username: "",
        password: "",
    });

    const [errorMessage, setErrorMessage] = useState("");
    const handleLogin = (e) => {
    e.preventDefault();

    const { username, password } = formData;

    if (!username || !password) {
        setErrorMessage("Please enter both username and password");
        return;
    }

    axios
        .post(`${SERVER_SIDE_API_ROOT}/login-action.php`, {
            username,
            password,
        })
        .then((res) => {
            if (res.data.status === "success") {
                localStorage.setItem("token", res.data.token);
                setErrorMessage("");
                setTimeout(() => {
                    window.location.href = "/dashboard";
                }, 1000);
            } else {
                setErrorMessage(res.data.message);
            }
        })
        .catch((err) => {
            setErrorMessage("Server error: " + err.message);
        });
};

return (
<div className="admin-wrapper">
    <div
       className="card-container"
       style={{ maxWidth: "400px", margin: "154px auto" }}>
     <h2>Login</h2>
     <form onSubmit={handleLogin}>
        <div>
            <label>Username:</label>
            <input
                value={formData.username}
                onChange={(e) =>
                    setFormData({ ...formData, username: e.target.value })
                }
            />
        </div>
        <div>
            <label>Password:</label>
            <input
                type="password"
                value={formData.password}
                onChange={(e) =>
                    setFormData({ ...formData, password: e.target.value })
                }
            />
        </div>
        {errorMessage && (
            <div className="alert alert-danger" role="alert">
                {errorMessage}
            </div>
        )}
        <button type="submit">Login</button>
        <p style={{ textAlign: "center", marginTop: "10px" }}>
            Don’t have an account?{" "}
            <Link to="/registerform" style={{ color: "#232323", fontWeight: "600", textDecoration: "none" }}>
                Register here
            </Link>
         </p>
      </form>
    </div>
</div>
);
};

export default LoginForm;
