<?php
header("Access-Control-Allow-Origin: *");
header("Access-Control-Allow-Headers: Content-Type, Authorization");
header("Access-Control-Allow-Methods: POST, OPTIONS");
header("Content-Type: application/json");

include "db.php";
require 'vendor/autoload.php'; 

use Firebase\JWT\JWT;
use Firebase\JWT\Key;

$secret_key = "MY_SECRET_KEY_12345"; 


if ($_SERVER['REQUEST_METHOD'] == 'OPTIONS') {
    http_response_code(200);
    exit;
}


$data = json_decode(file_get_contents("php://input"));

if (!isset($data->username) || !isset($data->password)) {
    echo json_encode(["status" => "error", "message" => "Missing credentials"]);
    exit;
}

$username = $conn->real_escape_string($data->username);
$password = $data->password;


$result = $conn->query("SELECT * FROM users WHERE username = '$username' LIMIT 1");

if ($result->num_rows === 0) {
    echo json_encode(["status" => "error", "message" => "User not found"]);
    exit;
}

$user = $result->fetch_assoc();


if (!password_verify($password, $user['password'])) {
    echo json_encode(["status" => "error", "message" => "Invalid password"]);
    exit;
}


$payload = [
    "iss" => "http://localhost",    
    "aud" => "http://localhost",    
    "iat" => time(),                 
    "exp" => time() + (60 * 60),     
    "user" => [
        "id" => $user['id'],
        "username" => $user['username'],
        "email" => $user['email']
    ]
];

$jwt = JWT::encode($payload, $secret_key, 'HS256');

echo json_encode([
    "status" => "success",
    "message" => "Login successful",
    "token" => $jwt
]);
?>
