import { useState } from "react";
import axios from "axios";
import { ToastContainer, toast } from "react-toastify";
import "react-toastify/dist/ReactToastify.css";
import "../../public/assets/css/phppot-style.css";
import PaymentFormFields from "./PaymentFormFields";

const GOOGLE_SHEET_URL =
  "Paste your Google Apps Script Web App URL here";

const ReactForm = () => {
  const [formData, setFormData] = useState({
    projectName: "",
    amount: "",
    currency: "",
    paymentDate: "",
    invoiceNumber: "",
    paymentMode: "",
    note: "",
  });
  const [loading, setLoading] = useState(false);

  const handleChange = (e) => {
    const { name, value } = e.target;
    setFormData((prev) => ({ ...prev, [name]: value }));
  };

  const handleSubmit = async (e) => {
    e.preventDefault();
    setLoading(true);
    try {
      const params = new URLSearchParams(formData).toString();
      const response = await axios.post(`${GOOGLE_SHEET_URL}?${params}`);

      if (response.data.status === "success") {
        toast.success("Data saved to Google Sheet!", { position: "top-center" });
        setFormData({
          projectName: "",
          amount: "",
          currency: "",
          paymentDate: "",
          invoiceNumber: "",
          paymentMode: "",
          note: "",
        });
      } else {
        toast.error("Failed to save data. Try again.", { position: "top-center" });
      }
    } catch (error) {
      console.error("Error:", error);
      toast.error("Something went wrong while submitting.", {
        position: "top-center",
      });
    }
    setLoading(false);
  };

  return (
    <div className="form-wrapper">
      <h2 className="form-title">Payment Entry</h2>
      <form onSubmit={handleSubmit} className="payment-form">
        <PaymentFormFields formData={formData} handleChange={handleChange} />
        <button type="submit" className="submit-btn" disabled={loading}>
          {loading ? "Processing..." : "Submit"}
        </button>
      </form>
      <ToastContainer />
    </div>
  );
};

export default ReactForm;
