const PaymentFormFields = ({ formData, handleChange }) => {
  return (
    <>
      <div className="form-group">
        <label className="form-label">Project Name</label>
        <input type="text" name="projectName" value={formData.projectName}
          onChange={handleChange}
          className="form-input"
          required
        />
      </div>
      <div className="form-group">
        <label className="form-label">Amount</label>
        <input type="number" name="amount" value={formData.amount}
          onChange={handleChange}
          className="form-input"
          required
        />
      </div>
      <div className="form-group">
        <label className="form-label">Currency</label>
        <select name="currency" value={formData.currency}
          onChange={handleChange}
          className="form-input"
          required
        >
          <option value="">Select Currency</option>
          <option value="USD">USD</option>
          <option value="INR">INR</option>
          <option value="EUR">EUR</option>
        </select>
      </div>
      <div className="form-group">
        <label className="form-label">Payment Date</label>
        <input type="date" name="paymentDate" value={formData.paymentDate}
          onChange={handleChange}
          className="form-input"
          required
        />
      </div>
      <div className="form-group">
        <label className="form-label">Invoice Number</label>
        <input type="text" name="invoiceNumber" value={formData.invoiceNumber}
          onChange={handleChange}
          className="form-input"
          required
        />
      </div>
      <div className="form-group">
        <label className="form-label">Payment Mode</label>
        <select name="paymentMode" value={formData.paymentMode}
          onChange={handleChange}
          className="form-input"
          required
        >
          <option value="">Select Mode</option>
          <option value="Cash">Cash</option>
          <option value="Bank Transfer">Bank Transfer</option>
          <option value="Credit Card">Credit Card</option>
          <option value="UPI">UPI</option>
        </select>
      </div>
      <div className="form-group">
        <label className="form-label">Note</label>
        <textarea name="note" value={formData.note}
          onChange={handleChange}
          className="form-input"
          rows="3"
        ></textarea>
      </div>
    </>
  );
};

export default PaymentFormFields;
