function doPost(e) {
  if (!e || !e.parameter) {
    return ContentService
      .createTextOutput(JSON.stringify({ status: "error", message: "No parameters received" }))
      .setMimeType(ContentService.MimeType.JSON);
  }
  const sheet = SpreadsheetApp.getActiveSpreadsheet().getSheetByName("Sheet1");
  const row = [
    e.parameter.projectName || "",
    e.parameter.amount || "",
    e.parameter.currency || "",
    e.parameter.paymentDate || "",
    e.parameter.invoiceNumber || "",
    e.parameter.paymentMode || "",
    e.parameter.note || "",
  ];
  sheet.appendRow(row);
  
  // These 5 line are for maintaining a same style across all the rows
  const lastRow = sheet.getLastRow();
  const lastColumn = sheet.getLastColumn();
  const headerRange = sheet.getRange(1, 1, 1, lastColumn);
  const newRowRange = sheet.getRange(lastRow, 1, 1, lastColumn);
  headerRange.copyTo(newRowRange, { formatOnly: true });
  
  return ContentService
    .createTextOutput(JSON.stringify({ status: "success" }))
    .setMimeType(ContentService.MimeType.JSON);
}
