const UploadBox = ({ dragActive, uploading, errorMsg, handleDrop, setDragActive }) => (
  <>
    <div
      className={`upload-box ${dragActive ? "active" : ""}`}
      onDragOver={(e) => {
        e.preventDefault();
        setDragActive(true);
      }}
      onDragLeave={() => setDragActive(false)}
      onDrop={handleDrop}
    >
      <h3 className="upload-title">Drag & Drop Files Here</h3>
      <p className="upload-text">Files will upload automatically</p>
    </div>
    {uploading && <p className="uploading-text">Uploading...</p>}
    {errorMsg && <p className="error-text">{errorMsg}</p>}
  </>
);

export default UploadBox;
