const FilePreview = ({ files, uploading }) => {
  if (!files.length) return null;

  return (
    <div className="preview-list">
      {files.map((file, i) => (
        <div key={i} className="preview-row">
          {file.type?.startsWith("image/") ? (
            <div className="preview-thumb-wrapper">
              <img
                src={URL.createObjectURL(file)}
                alt={file.name}
                className={`preview-thumb ${uploading ? "blurred" : ""}`}
              />
              {uploading && ( <div className="preview-loader">
                <img src="/assets/image/loader.svg" alt="Loading..." />
               </div>
              )}
            </div>
          ) : (
            <div className="file-icon">📄</div>
          )}
          <div className="file-info">
            <p className="file-name">{file.name}</p>
            <p className="file-size">{Math.round(file.size / 1024)} KB</p>
          </div>
        </div>
      ))}
    </div>
  );
};

export default FilePreview;
