<?php
header("Access-Control-Allow-Origin: *");
header("Access-Control-Allow-Methods: POST, GET, OPTIONS");
header("Access-Control-Allow-Headers: Content-Type");

include "db.php";

$uploadDir = "uploads/";
$response = [];

if (!file_exists($uploadDir)) {
    mkdir($uploadDir, 0777, true);
}

$allowedExtensions = ['jpg', 'jpeg', 'png', 'gif', 'pdf', 'txt', 'doc', 'docx'];
$maxFileSize = 2 * 1024 * 1024; 

foreach ($_FILES['files']['name'] as $key => $name) {
    $tmpName = $_FILES['files']['tmp_name'][$key];
    $extension = strtolower(pathinfo($name, PATHINFO_EXTENSION));
    $size = $_FILES['files']['size'][$key];

    if (!in_array($extension, $allowedExtensions)) {
        $response[] = [
            "name" => $name,
            "status" => "blocked",
            "message" => "File type not allowed (.{$extension})"
        ];
        continue;
    }
    if ($size > $maxFileSize) {
        $response[] = [
            "name" => $name,
            "status" => "blocked",
            "message" => "Maximum file size is 2M."
        ];
        continue;
    }
    if ($size <= 0) {
        $response[] = [
            "name" => $name,
            "status" => "blocked",
            "message" => "Empty file"
        ];
        continue;
    }
    $uniqueName = uniqid() . "_" . basename($name);
    $targetPath = $uploadDir . $uniqueName;

    if (move_uploaded_file($tmpName, $targetPath)) {
        $stmt = $conn->prepare("INSERT INTO uploaded_files (file_name, file_path) VALUES (?, ?)");
        $stmt->bind_param("ss", $uniqueName, $targetPath);
        $stmt->execute();
        $response[] = [
            "name" => $name,
            "path" => $targetPath,
            "status" => "uploaded"
        ];
    } else {
        $response[] = [
            "name" => $name,
            "status" => "failed",
            "message" => "Error moving uploaded file."
        ];
    }
}

echo json_encode(["success" => true, "files" => $response]);
?>
