import { TrendingUp, BarChart3, Users, Activity } from "lucide-react";

const StatsCards = () => {
  const stats = [
    { icon: <TrendingUp strokeWidth={1} />, label: "Total Sales", value: "$24,850", change: "+12.5%" },
    { icon: <BarChart3 strokeWidth={1} />, label: "Revenue", value: "$48,200", change: "+8.2%" },
    { icon: <Users strokeWidth={1} />, label: "Users", value: "12,543", change: "+23.1%" },
    { icon: <Activity strokeWidth={1} />, label: "Growth", value: "34.8%", change: "+5.4%" },
  ];

  return (
    <div className="stats-grid">
      {stats.map((stat, index) => (
        <div key={index} className="stat-card">
          <div className="stat-top">
            <span className="stat-icon">{stat.icon}</span>
            <span className="stat-change">{stat.change}</span>
          </div>

          <p className="stat-label">{stat.label}</p>
          <p className="stat-value">{stat.value}</p>
        </div>
      ))}
    </div>
  );
};

export default StatsCards;
