import { PieChart, Pie, Tooltip, ResponsiveContainer, Cell } from "recharts";

const PieChartBox = ({ data }) => (
  <div className="chart-card">
    <h2>Browser Distribution</h2>

    <ResponsiveContainer width="100%" height={300}>
      <PieChart>
        <Pie
          data={data}
          dataKey="value"
          innerRadius={60}
          outerRadius={100}
          paddingAngle={2}
          cx="50%"
          cy="50%"
        >
          {data.map((entry, i) => (
            <Cell key={i} fill={entry.color} />
          ))}
        </Pie>
        <Tooltip />
      </PieChart>
    </ResponsiveContainer>

    <div className="pie-legend">
      {data.map((item, i) => (
        <div key={i} className="legend-item">
          <span className="legend-color" style={{ background: item.color }} />
          <span>{item.name}: {item.value}%</span>
        </div>
      ))}
    </div>
  </div>
);

export default PieChartBox;
