import { LineChart, Line, XAxis, YAxis, Tooltip, CartesianGrid, Legend, ResponsiveContainer } from "recharts";

const LineChartBox = ({ data }) => (
  <div className="chart-card">
    <h2>Sales & Revenue Trend</h2>
    <ResponsiveContainer width="100%" height={300}>
      <LineChart data={data}>
        <CartesianGrid strokeDasharray="3 3" stroke="#475569" />
        <XAxis stroke="#94a3b8" />
        <YAxis stroke="#94a3b8" />
        <Tooltip />
        <Legend />
        <Line type="monotone" dataKey="sales" stroke="#3b82f6" strokeWidth={1} />
        <Line type="monotone" dataKey="revenue" stroke="#10b981" strokeWidth={1} />
      </LineChart>
    </ResponsiveContainer>
  </div>
);

export default LineChartBox;
