import { useState, useEffect } from "react";

import Header from "../components/Header";
import StatsCards from "../components/StatsCards";
import LineChartBox from "../components/LineChartBox";
import BarChartBox from "../components/BarChartBox";
import PieChartBox from "../components/PieChartBox";
import AreaChartBox from "../components/AreaChartBox";
import Footer from "../components/Footer";

const DataVisualization = () => {
  const [lineData, setLineData] = useState([]);
  const [barData, setBarData] = useState([]);
  const [pieData, setPieData] = useState([]);
  const [areaData, setAreaData] = useState([]);

  useEffect(() => {
    fetch("/data/dashboard.json")
      .then((res) => res.json())
      .then((data) => {
        setLineData(data.lineData);
        setBarData(data.barData);
        setPieData(data.pieData);
        setAreaData(data.areaData);
      })
      .catch((err) => console.error("Error loading data:", err));
  }, []);

  return (
    <div className="dashboard-wrapper">
      <div className="dashboard-container">
        <Header />
        <StatsCards />
        <div className="charts-grid">
          <LineChartBox data={lineData} />
          <BarChartBox data={barData} />
          <PieChartBox data={pieData} />
          <AreaChartBox data={areaData} />
        </div>
        <Footer />
      </div>
    </div>
  );
};

export default DataVisualization;
