import { AreaChart, Area, XAxis, YAxis, Tooltip, CartesianGrid, ResponsiveContainer } from "recharts";

const AreaChartBox = ({ data }) => (
  <div className="chart-card">
    <h2>Active Users Over Time</h2>

    <ResponsiveContainer width="100%" height={300}>
      <AreaChart data={data}>
        <defs>
          <linearGradient id="colorUsers" x1="0" y1="0" x2="0" y2="1">
            <stop offset="5%" stopColor="#f59e0b" stopOpacity={0.8} />
            <stop offset="95%" stopColor="#f59e0b" stopOpacity={0} />
          </linearGradient>
        </defs>

        <CartesianGrid strokeDasharray="3 3" stroke="#475569" />
        <XAxis dataKey="time" stroke="#94a3b8" />
        <YAxis stroke="#94a3b8" />
        <Tooltip />

        <Area
          type="monotone"
          dataKey="users"
          stroke="#f59e0b"
          fill="url(#colorUsers)"
        />
      </AreaChart>
    </ResponsiveContainer>
  </div>
);

export default AreaChartBox;
